/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.HumanSoldierToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class GeneralsEnforcerEffect
extends OneShotEffect {
    private static final Token token = new HumanSoldierToken();

    GeneralsEnforcerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target card from a graveyard. If it was a creature card, create a 1/1 white Human Soldier creature token.";
    }

    private GeneralsEnforcerEffect(GeneralsEnforcerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GeneralsEnforcerEffect copy() {
        return new GeneralsEnforcerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        boolean isCreature = card.isCreature(game);
        if (player.moveCards(card, Zone.EXILED, source, game) && isCreature) {
            token.putOntoBattlefield(1, game, source, source.getControllerId());
        }
        return true;
    }
}

