/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetSource;

class GeneralsRegaliaEffect
extends RedirectionEffect {
    private final TargetSource damageSource;

    public GeneralsRegaliaEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next time a source of your choice would deal damage to you this turn, that damage is dealt to target creature you control instead";
        this.damageSource = new TargetSource();
    }

    private GeneralsRegaliaEffect(GeneralsRegaliaEffect effect) {
        super((RedirectionEffect)effect);
        this.damageSource = effect.damageSource.copy();
    }

    public GeneralsRegaliaEffect copy() {
        return new GeneralsRegaliaEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.damageSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        if (object == null) {
            game.informPlayers("Couldn't find source of damage");
            return false;
        }
        if (!(object.getId().equals(this.damageSource.getFirstTarget()) || object instanceof Spell && ((Spell)object).getSourceId().equals(this.damageSource.getFirstTarget()))) {
            return false;
        }
        this.redirectTarget = (Target)source.getTargets().get(0);
        Player player = game.getPlayer(event.getTargetId());
        return player != null && player.getId().equals(source.getControllerId());
    }
}

