/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class GhastlordOfFugueEffect
extends OneShotEffect {
    GhastlordOfFugueEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player reveals their hand. You choose a card from it. That player exiles that card";
    }

    private GhastlordOfFugueEffect(GhastlordOfFugueEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (targetPlayer != null && sourceObject != null && controller != null) {
            targetPlayer.revealCards(sourceObject.getName(), targetPlayer.getHand(), game);
            TargetCard target = new TargetCard(Zone.HAND, new FilterCard());
            target.withNotTarget(true);
            Card chosenCard = null;
            if (controller.choose(Outcome.Benefit, targetPlayer.getHand(), target, source, game)) {
                chosenCard = game.getCard(target.getFirstTarget());
            }
            if (chosenCard != null) {
                controller.moveCards(chosenCard, Zone.EXILED, source, game);
            }
            return true;
        }
        return false;
    }

    public GhastlordOfFugueEffect copy() {
        return new GhastlordOfFugueEffect(this);
    }
}

