/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.stream.Collectors;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.UnearthAbility;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.filter.FilterCard;
import mage.filter.common.FilterArtifactCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class GhostArkEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterArtifactCard();

    GhostArkEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "each artifact creature card in your graveyard gains unearth {3} until end of turn";
    }

    private GhostArkEffect(GhostArkEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return;
        }
        this.affectedObjectList.addAll(player.getGraveyard().getCards(filter, game).stream().map(card -> new MageObjectReference((MageObject)card, game)).collect(Collectors.toSet()));
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        for (MageObjectReference mor : this.affectedObjectList) {
            Card card = mor.getCard(game);
            if (card == null) continue;
            UnearthAbility ability = new UnearthAbility((Cost)new ManaCostsImpl("{3}"));
            ability.setSourceId(card.getId());
            ability.setControllerId(card.getOwnerId());
            game.getState().addOtherAbility(card, (Ability)ability);
        }
        return true;
    }

    public GhostArkEffect copy() {
        return new GhostArkEffect(this);
    }

    static {
        filter.add((Predicate)CardType.CREATURE.getPredicate());
    }
}

