/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class GhostOfRamirezDePietroWatcher
extends Watcher {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    GhostOfRamirezDePietroWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case ZONE_CHANGE: {
                ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
                if (zEvent.getFromZone() != Zone.LIBRARY || zEvent.getToZone() != Zone.GRAVEYARD) break;
            }
            case DISCARDED_CARD: {
                this.morSet.add(new MageObjectReference(event.getTargetId(), game));
            }
        }
    }

    public void reset() {
        super.reset();
        this.morSet.clear();
    }

    boolean checkCard(Card card, Game game) {
        return this.morSet.stream().anyMatch(mor -> mor.refersTo((MageObject)card, game));
    }
}

