/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class GiadaFontOfHopeEntersBattlefieldEffect
extends ReplacementEffectImpl {
    GiadaFontOfHopeEntersBattlefieldEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "Each other Angel you control enters with an additional +1/+1 counter on it for each Angel you already control.";
    }

    private GiadaFontOfHopeEntersBattlefieldEffect(GiadaFontOfHopeEntersBattlefieldEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        int amount;
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent != null && (amount = (int)game.getBattlefield().getAllActivePermanents().stream().filter(perm -> perm.hasSubtype(SubType.ANGEL, game) && perm.isControlledBy(source.getControllerId())).count()) > 0) {
            permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.hasSubtype(SubType.ANGEL, game) && !event.getTargetId().equals(source.getSourceId());
    }

    public GiadaFontOfHopeEntersBattlefieldEffect copy() {
        return new GiadaFontOfHopeEntersBattlefieldEffect(this);
    }
}

