/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.ForestwalkAbility;
import mage.abilities.keyword.IslandwalkAbility;
import mage.abilities.keyword.MountainwalkAbility;
import mage.abilities.keyword.PlainswalkAbility;
import mage.abilities.keyword.SwampwalkAbility;
import mage.choices.Choice;
import mage.choices.ChoiceBasicLandType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GiantSlugEffect
extends OneShotEffect {
    GiantSlugEffect() {
        super(Outcome.AddAbility);
        this.staticText = "At the beginning of your next upkeep, choose a basic land type. {this} gains landwalk of the chosen type until the end of that turn";
    }

    private GiantSlugEffect(GiantSlugEffect effect) {
        super((OneShotEffect)effect);
    }

    public GiantSlugEffect copy() {
        return new GiantSlugEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller == null || sourcePermanent == null) {
            return false;
        }
        ChoiceBasicLandType choices = new ChoiceBasicLandType();
        if (!controller.choose(this.outcome, (Choice)choices, game)) {
            return false;
        }
        game.informPlayers(sourcePermanent.getName() + ":  Chosen basic land type is " + choices.getChoice());
        switch (choices.getChoice()) {
            case "Plains": {
                game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new PlainswalkAbility(), Duration.EndOfTurn), source);
                return true;
            }
            case "Island": {
                game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new IslandwalkAbility(), Duration.EndOfTurn), source);
                return true;
            }
            case "Swamp": {
                game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new SwampwalkAbility(), Duration.EndOfTurn), source);
                return true;
            }
            case "Mountain": {
                game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new MountainwalkAbility(), Duration.EndOfTurn), source);
                return true;
            }
            case "Forest": {
                game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new ForestwalkAbility(), Duration.EndOfTurn), source);
                return true;
            }
        }
        return false;
    }
}

