/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GideonBattleForgedEffect
extends RequirementEffect {
    protected MageObjectReference targetPermanentReference;

    GideonBattleForgedEffect() {
        super(Duration.Custom);
        this.staticText = "up to one target creature an opponent controls attacks {this} during its controller's next turn if able";
    }

    private GideonBattleForgedEffect(GideonBattleForgedEffect effect) {
        super((RequirementEffect)effect);
        this.targetPermanentReference = effect.targetPermanentReference;
    }

    public GideonBattleForgedEffect copy() {
        return new GideonBattleForgedEffect(this);
    }

    public boolean isInactive(Ability source, Game game) {
        if (this.targetPermanentReference == null) {
            return true;
        }
        Permanent targetPermanent = this.targetPermanentReference.getPermanent(game);
        if (targetPermanent == null) {
            return true;
        }
        return game.getTurnPhaseType() == TurnPhase.END && this.isYourNextTurn(game);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        if (this.getTargetPointer().getFirst(game, source) == null) {
            this.discard();
        } else {
            this.targetPermanentReference = new MageObjectReference(this.getTargetPointer().getFirst(game, source), game);
        }
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (!permanent.getId().equals(this.getTargetPointer().getFirst(game, source)) || !game.isActivePlayer(permanent.getControllerId())) {
            return false;
        }
        Permanent planeswalker = source.getSourcePermanentIfItStillExists(game);
        if (planeswalker == null) {
            this.discard();
            return false;
        }
        return true;
    }

    public UUID mustAttackDefender(Ability source, Game game) {
        return source.getSourceId();
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

