/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GideonsDefeatEffect
extends OneShotEffect {
    GideonsDefeatEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target white creature that's attacking or blocking. If it was a Gideon planeswalker, you gain 5 life";
    }

    private GideonsDefeatEffect(GideonsDefeatEffect effect) {
        super((OneShotEffect)effect);
    }

    public GideonsDefeatEffect copy() {
        return new GideonsDefeatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && permanent != null) {
            controller.moveCards((Card)permanent, Zone.EXILED, source, game);
            game.processAction();
            if (permanent.isPlaneswalker(game) && permanent.hasSubtype(SubType.GIDEON, game)) {
                controller.gainLife(5, game, source);
            }
            return true;
        }
        return false;
    }
}

