/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class GideonsInterventionPreventAllDamageEffect
extends PreventionEffectImpl {
    GideonsInterventionPreventAllDamageEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Prevent all damage that would be dealt to you and permanents you control by sources with the chosen name.";
    }

    private GideonsInterventionPreventAllDamageEffect(GideonsInterventionPreventAllDamageEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public GideonsInterventionPreventAllDamageEffect copy() {
        return new GideonsInterventionPreventAllDamageEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventDamageEvent preventEvent = new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage());
        if (!game.replaceEvent((GameEvent)preventEvent)) {
            int damage = event.getAmount();
            event.setAmount(0);
            game.informPlayers("Damage has been prevented: " + damage);
            game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        Permanent targetPerm = game.getPermanent(event.getTargetId());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (object != null && (event.getType() == GameEvent.EventType.DAMAGE_PLAYER || targetPerm != null && event.getType() == GameEvent.EventType.DAMAGE_PERMANENT) && CardUtil.haveSameNames((MageObject)object, (String)cardName, (Game)game) && (event.getTargetId().equals(source.getControllerId()) || targetPerm != null && targetPerm.isControlledBy(source.getControllerId()))) {
            return super.applies(event, source, game);
        }
        return false;
    }
}

