/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class GideonsTriumphWatcher
extends Watcher {
    private final Set<MageObjectReference> attackedOrBlockedThisTurnCreatures = new HashSet<MageObjectReference>();

    public GideonsTriumphWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED || event.getType() == GameEvent.EventType.BLOCKER_DECLARED) {
            this.attackedOrBlockedThisTurnCreatures.add(new MageObjectReference(event.getSourceId(), game));
        }
    }

    boolean attackedOrBlockedThisTurn(Permanent permanent, Game game) {
        return this.attackedOrBlockedThisTurnCreatures.contains(new MageObjectReference((MageObject)permanent, game));
    }

    public void reset() {
        this.attackedOrBlockedThisTurnCreatures.clear();
    }
}

