/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class GiftOfDoomEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    GiftOfDoomEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may attach it to a creature";
    }

    private GiftOfDoomEffect(GiftOfDoomEffect effect) {
        super((OneShotEffect)effect);
    }

    public GiftOfDoomEffect copy() {
        return new GiftOfDoomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent giftOfDoom = game.getPermanent(source.getSourceId());
        if (player == null || giftOfDoom == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        if (player.choose(this.outcome, (Target)target, source, game) && game.getPermanent(target.getFirstTarget()) != null && !game.getPermanent(target.getFirstTarget()).cantBeAttachedBy((MageObject)giftOfDoom, source, game, false)) {
            game.getState().setValue("attachTo:" + giftOfDoom.getId(), (Object)target.getFirstTarget());
            game.getPermanent(target.getFirstTarget()).addAttachment(giftOfDoom.getId(), source, game);
            return true;
        }
        player.moveCardToGraveyardWithInfo((Card)giftOfDoom, source, game, Zone.BATTLEFIELD);
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

