/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldAttachedEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class GiftOfImmortalityEffect
extends OneShotEffect {
    GiftOfImmortalityEffect() {
        super(Outcome.Benefit);
        this.staticText = "return that card to the battlefield under its owner's control. Return {this} to the battlefield attached to that creature at the beginning of the next end step";
    }

    private GiftOfImmortalityEffect(GiftOfImmortalityEffect effect) {
        super((OneShotEffect)effect);
    }

    public GiftOfImmortalityEffect copy() {
        return new GiftOfImmortalityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || enchantment == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Permanent enchanted = (Permanent)game.getLastKnownInformation(enchantment.getAttachedTo(), Zone.BATTLEFIELD);
        Card card = game.getCard(enchantment.getAttachedTo());
        if (card == null || enchanted == null || card.getZoneChangeCounter(game) != enchanted.getZoneChangeCounter(game) + 1) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        ReturnToBattlefieldAttachedEffect effect = new ReturnToBattlefieldAttachedEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
        return true;
    }
}

