/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.PutCards;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GilraenDunedainProtectorEffect
extends OneShotEffect {
    private static final Counters counters = new Counters(new Counter[0]);

    GilraenDunedainProtectorEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile another target creature you control. You may return that card to the battlefield under its owner's control. If you don't, at the beginning of the next end step, return that card to the battlefield under its owner's control with a vigilance counter and a lifelink counter on it.";
    }

    private GilraenDunedainProtectorEffect(GilraenDunedainProtectorEffect effect) {
        super((OneShotEffect)effect);
    }

    public GilraenDunedainProtectorEffect copy() {
        return new GilraenDunedainProtectorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent == null || controller == null || sourcePermanent == null) {
            return false;
        }
        permanent.moveToExile(source.getSourceId(), sourcePermanent.getName(), source, game);
        game.processAction();
        Card card = game.getExile().getCard(permanent.getId(), game);
        boolean choice = controller.chooseUse(Outcome.Neutral, "Return that card to the battlefield now?", source, game);
        if (choice) {
            if (card != null) {
                PutCards.BATTLEFIELD.moveCards(game.getPlayer(card.getOwnerId()), (Cards)new CardsImpl(card), source, game);
            }
        } else {
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect(new MageObjectReference((MageObject)card, game), counters, "a vigilance counter and a lifelink counter")), source);
        }
        return true;
    }

    static {
        counters.addCounter(CounterType.VIGILANCE.createInstance()).addCounter(CounterType.LIFELINK.createInstance());
    }
}

