/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.FightTargetSourceEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.watchers.common.AbilityResolvedWatcher;

class GimliMournfulAvengerEffect
extends OneShotEffect {
    GimliMournfulAvengerEffect() {
        super(Outcome.Benefit);
        this.staticText = "when this ability resolves for the third time this turn, {this} fights up to one target creature you don't control.";
    }

    private GimliMournfulAvengerEffect(GimliMournfulAvengerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GimliMournfulAvengerEffect copy() {
        return new GimliMournfulAvengerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (AbilityResolvedWatcher.getResolutionCount((Game)game, (Ability)source) != 3) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new FightTargetSourceEffect(), false);
        ability.addTarget((Target)new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL));
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

