/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.PhyrexianGoblinToken;
import mage.players.Player;

class GleefulDemolitionEffect
extends OneShotEffect {
    GleefulDemolitionEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target artifact. If you controlled that artifact, create three 1/1 red Phyrexian Goblin creature tokens";
    }

    private GleefulDemolitionEffect(GleefulDemolitionEffect effect) {
        super((OneShotEffect)effect);
    }

    public GleefulDemolitionEffect copy() {
        return new GleefulDemolitionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || player == null) {
            return false;
        }
        boolean isMine = permanent.isControlledBy(source.getControllerId());
        permanent.destroy(source, game, false);
        if (isMine) {
            PhyrexianGoblinToken token = new PhyrexianGoblinToken();
            token.putOntoBattlefield(3, game, source);
        }
        return true;
    }
}

