/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class GlimmerLensTriggeredAbility
extends TriggeredAbilityImpl {
    GlimmerLensTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
        this.setTriggerPhrase("Whenever equipped creature and at least one other creature attack, ");
    }

    private GlimmerLensTriggeredAbility(GlimmerLensTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GlimmerLensTriggeredAbility copy() {
        return new GlimmerLensTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attachment = this.getSourcePermanentOrLKI(game);
        if (attachment == null) {
            return false;
        }
        UUID equippedCreature = attachment.getAttachedTo();
        if (!game.getCombat().getAttackers().contains(equippedCreature)) return false;
        if (!game.getCombat().getAttackers().stream().filter(uuid -> !equippedCreature.equals(uuid)).map(arg_0 -> ((Game)game).getPermanent(arg_0)).anyMatch(Objects::nonNull)) return false;
        return true;
    }
}

