/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class GlimmerpostEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public GlimmerpostEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain 1 life for each Locus on the battlefield";
    }

    private GlimmerpostEffect(GlimmerpostEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int amount = game.getBattlefield().count(filter, source.getControllerId(), source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.gainLife(amount, game, source);
            return true;
        }
        return false;
    }

    public GlimmerpostEffect copy() {
        return new GlimmerpostEffect(this);
    }

    static {
        filter.add((Predicate)SubType.LOCUS.getPredicate());
    }
}

