/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageIdentifier;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GlimpseTheCosmosPlayEffect
extends AsThoughEffectImpl {
    GlimpseTheCosmosPlayEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "As long as you control a Giant, you may cast {this} from your graveyard by paying {U} rather than paying its mana cost";
    }

    private GlimpseTheCosmosPlayEffect(GlimpseTheCosmosPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public GlimpseTheCosmosPlayEffect copy() {
        return new GlimpseTheCosmosPlayEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Player controller;
        if (sourceId.equals(source.getSourceId()) && source.isControlledBy(affectedControllerId) && game.getState().getZone(source.getSourceId()) == Zone.GRAVEYARD && (controller = game.getPlayer(affectedControllerId)) != null) {
            controller.setCastSourceIdWithAlternateMana(sourceId, (ManaCosts)new ManaCostsImpl("{U}"), null, MageIdentifier.GlimpseTheCosmosWatcher);
            return true;
        }
        return false;
    }
}

