/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.g.GlimpseTheCosmosWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.players.Player;

class GlimpseTheCosmosReplacementEffect
extends ReplacementEffectImpl {
    GlimpseTheCosmosReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Benefit);
        this.staticText = "As long as you control a Giant, you may cast {this} from your graveyard by paying {U} rather than paying its mana cost. If you cast {this} this way and it would be put into your graveyard, exile it instead";
    }

    private GlimpseTheCosmosReplacementEffect(GlimpseTheCosmosReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GlimpseTheCosmosReplacementEffect copy() {
        return new GlimpseTheCosmosReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (card = game.getCard(event.getTargetId())) != null) {
            return controller.moveCards(card, Zone.EXILED, source, game, false, false, false, event.getAppliedEffects());
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        GlimpseTheCosmosWatcher watcher = (GlimpseTheCosmosWatcher)game.getState().getWatcher(GlimpseTheCosmosWatcher.class);
        return watcher != null && ((ZoneChangeEvent)event).getFromZone() == Zone.STACK && ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && event.getTargetId().equals(source.getSourceId()) && watcher.isCardSource(game.getCard(source.getSourceId()));
    }
}

