/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.token.EldraziSpawnToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.util.CardUtil;

class GlimpseTheImpossibleEffect
extends OneShotEffect {
    GlimpseTheImpossibleEffect() {
        super(Outcome.Benefit);
        this.staticText = "put them into your graveyard, then create a 0/1 colorless Eldrazi Spawn creature token for each card put into your graveyard this way. Those tokens have \"Sacrifice this creature: Add {C}.\"";
    }

    private GlimpseTheImpossibleEffect(GlimpseTheImpossibleEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlimpseTheImpossibleEffect copy() {
        return new GlimpseTheImpossibleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (controller == null || exileZone == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(exileZone.getCards(game));
        controller.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        game.processAction();
        cards.retainZone(Zone.GRAVEYARD, game);
        new CreateTokenEffect((Token)new EldraziSpawnToken(), cards.size()).apply(game, source);
        return true;
    }
}

