/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;

class GloriousGaleEffect
extends OneShotEffect {
    GloriousGaleEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target creature spell. If it was a legendary spell, the Ring tempts you";
    }

    private GloriousGaleEffect(GloriousGaleEffect effect) {
        super((OneShotEffect)effect);
    }

    public GloriousGaleEffect copy() {
        return new GloriousGaleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            return false;
        }
        game.getStack().counter(spell.getId(), source, game);
        if (spell.isLegendary(game)) {
            game.temptWithTheRing(source.getControllerId());
        }
        return true;
    }
}

