/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceHasCounterCondition;
import mage.abilities.decorator.ConditionalContinuousRuleModifyingEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ContinuousRuleModifyingEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersUntapStepSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.counter.RemoveCounterSourceEffect;
import mage.abilities.triggers.BeginningOfUpkeepTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GlyphOfDelusionEffect
extends OneShotEffect {
    GlyphOfDelusionEffect() {
        super(Outcome.Detriment);
        this.staticText = "Put X glyph counters on target creature that target Wall blocked this turn, where X is the power of that blocked creature. The creature gains \"This creature doesn't untap during your untap step if it has a glyph counter on it\" and \"At the beginning of your upkeep, remove a glyph counter from this creature.\"";
    }

    private GlyphOfDelusionEffect(GlyphOfDelusionEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlyphOfDelusionEffect copy() {
        return new GlyphOfDelusionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent;
        if (source.getTargets().get(1) != null && (targetPermanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget())) != null) {
            targetPermanent.addCounters(CounterType.GLYPH.createInstance(targetPermanent.getPower().getValue()), source.getControllerId(), source, game);
            SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new ConditionalContinuousRuleModifyingEffect((ContinuousRuleModifyingEffect)new DontUntapInControllersUntapStepSourceEffect(), (Condition)new SourceHasCounterCondition(CounterType.GLYPH)).setText("This creature doesn't untap during your untap step if it has a glyph counter on it"));
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)ability, Duration.Custom);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            BeginningOfUpkeepTriggeredAbility ability2 = new BeginningOfUpkeepTriggeredAbility((Effect)new RemoveCounterSourceEffect(CounterType.GLYPH.createInstance()));
            GainAbilityTargetEffect effect2 = new GainAbilityTargetEffect((Ability)ability2, Duration.Custom);
            effect2.setTargetPointer((TargetPointer)new FixedTarget(targetPermanent.getId(), game));
            game.addEffect((ContinuousEffect)effect2, source);
        }
        return false;
    }
}

