/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.RatCantBlockToken;
import mage.game.permanent.token.Token;

class GnawingCrescendoTriggeredAbility
extends DelayedTriggeredAbility {
    GnawingCrescendoTriggeredAbility() {
        super((Effect)new CreateTokenEffect((Token)new RatCantBlockToken()), Duration.EndOfTurn, false, false);
        this.setTriggerPhrase("Whenever a nontoken creature you control dies this turn, ");
    }

    private GnawingCrescendoTriggeredAbility(GnawingCrescendoTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public GnawingCrescendoTriggeredAbility copy() {
        return new GnawingCrescendoTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.isDiesEvent() && zEvent.getTarget() != null && zEvent.getTarget().isControlledBy(this.getControllerId()) && zEvent.getTarget().isCreature(game) && !(zEvent.getTarget() instanceof PermanentToken);
    }
}

