/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GoblinBangchuckersEffect
extends OneShotEffect {
    GoblinBangchuckersEffect() {
        super(Outcome.Damage);
        this.staticText = "Flip a coin. If you win the flip, {this} deals 2 damage to any target. If you lose the flip, {this} deals 2 damage to itself";
    }

    private GoblinBangchuckersEffect(GoblinBangchuckersEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.flipCoin(source, game, true)) {
                Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (permanent != null) {
                    permanent.damage(2, source.getSourceId(), source, game, false, true);
                    return true;
                }
                Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
                if (player != null) {
                    player.damage(2, source.getSourceId(), source, game);
                    return true;
                }
            } else {
                Permanent permanent = game.getPermanent(source.getSourceId());
                if (permanent != null) {
                    permanent.damage(2, source.getSourceId(), source, game, false, true);
                    return true;
                }
            }
        }
        return false;
    }

    public GoblinBangchuckersEffect copy() {
        return new GoblinBangchuckersEffect(this);
    }
}

