/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class GoblinBowlingTeamEffect
extends ReplacementEffectImpl {
    GoblinBowlingTeamEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If {this} would deal damage to a permanent or player, it deals that much damage plus the result of a six-sided die roll to that permanent or player instead";
    }

    private GoblinBowlingTeamEffect(GoblinBowlingTeamEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GoblinBowlingTeamEffect copy() {
        return new GoblinBowlingTeamEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getSourceId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            DamageEvent damageEvent = (DamageEvent)event;
            if (damageEvent.getType() == GameEvent.EventType.DAMAGE_PLAYER) {
                Player targetPlayer = game.getPlayer(event.getTargetId());
                if (targetPlayer != null) {
                    targetPlayer.damage(CardUtil.overflowInc((int)damageEvent.getAmount(), (int)controller.rollDice(Outcome.Benefit, source, game, 6)), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), event.getAppliedEffects());
                    return true;
                }
            } else {
                Permanent targetPermanent = game.getPermanent(event.getTargetId());
                if (targetPermanent != null) {
                    targetPermanent.damage(CardUtil.overflowInc((int)damageEvent.getAmount(), (int)controller.rollDice(Outcome.Benefit, source, game, 6)), damageEvent.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable(), event.getAppliedEffects());
                    return true;
                }
            }
        }
        return false;
    }
}

