/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.g.GoblinFestivalGainControlEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GoblinFestivalChangeControlEffect
extends OneShotEffect {
    GoblinFestivalChangeControlEffect() {
        super(Outcome.Benefit);
        this.staticText = "Flip a coin. If you lose the flip, choose one of your opponents. That player gains control of {this}";
    }

    private GoblinFestivalChangeControlEffect(GoblinFestivalChangeControlEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinFestivalChangeControlEffect copy() {
        return new GoblinFestivalChangeControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (controller != null && !controller.flipCoin(source, game, true) && sourcePermanent != null) {
            Player chosenOpponent;
            TargetOpponent target = new TargetOpponent(true);
            if (target.canChoose(controller.getId(), source, game)) {
                while (!target.isChosen(game) && target.canChoose(controller.getId(), source, game) && controller.canRespond()) {
                    controller.chooseTarget(this.outcome, (Target)target, source, game);
                }
            }
            if ((chosenOpponent = game.getPlayer(target.getFirstTarget())) != null) {
                GoblinFestivalGainControlEffect effect = new GoblinFestivalGainControlEffect(Duration.Custom, chosenOpponent.getId());
                effect.setTargetPointer((TargetPointer)new FixedTarget(sourcePermanent.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
                game.informPlayers(chosenOpponent.getLogName() + " has gained control of " + sourcePermanent.getLogName());
                return true;
            }
        }
        return false;
    }
}

