/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GoblinKaboomistFlipCoinEffect
extends OneShotEffect {
    GoblinKaboomistFlipCoinEffect() {
        super(Outcome.Damage);
        this.staticText = "Then flip a coin. If you lose the flip, {this} deals 2 damage to itself";
    }

    private GoblinKaboomistFlipCoinEffect(GoblinKaboomistFlipCoinEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinKaboomistFlipCoinEffect copy() {
        return new GoblinKaboomistFlipCoinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player != null && permanent != null) {
            if (!player.flipCoin(source, game, true)) {
                String message = permanent.getLogName() + " deals 2 damage to itself";
                game.informPlayers(message);
                permanent.damage(2, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

