/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GoblinSecretAgentEffect
extends OneShotEffect {
    GoblinSecretAgentEffect() {
        super(Outcome.Detriment);
        this.staticText = "reveal a card from your hand at random";
    }

    private GoblinSecretAgentEffect(GoblinSecretAgentEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinSecretAgentEffect copy() {
        return new GoblinSecretAgentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            if (!controller.getHand().isEmpty()) {
                CardsImpl randomCard = new CardsImpl();
                Card card = controller.getHand().getRandom(game);
                randomCard.add(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)randomCard, game);
            }
            return true;
        }
        return false;
    }
}

