/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInHandEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class GoblinTutorEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card named Goblin Tutor");

    public GoblinTutorEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Roll a six-sided die. If you roll a 1, {this} has no effect. Otherwise, search your library for the indicated card, reveal it, put it into your hand, then shuffle.<br>2 - A card named Goblin Tutor<br>3 - An enchantment<br>4 - An artifact<br>5 - A creature<br>6 - An instant or sorcery";
    }

    private GoblinTutorEffect(GoblinTutorEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinTutorEffect copy() {
        return new GoblinTutorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int amount = controller.rollDice(this.outcome, source, game, 6);
            SearchLibraryPutInHandEffect effect = null;
            if (amount == 2) {
                effect = new SearchLibraryPutInHandEffect(new TargetCardInLibrary(0, 1, filter), true);
            } else if (amount == 3) {
                effect = new SearchLibraryPutInHandEffect(new TargetCardInLibrary(0, 1, StaticFilters.FILTER_CARD_ENCHANTMENT), true);
            } else if (amount == 4) {
                effect = new SearchLibraryPutInHandEffect(new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_ARTIFACT), true);
            } else if (amount == 5) {
                effect = new SearchLibraryPutInHandEffect(new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE), true);
            } else if (amount == 6) {
                effect = new SearchLibraryPutInHandEffect(new TargetCardInLibrary(0, 1, (FilterCard)new FilterInstantOrSorceryCard()), true);
            }
            if (effect != null) {
                effect.apply(game, source);
                return true;
            }
        }
        return false;
    }

    static {
        filter.add((Predicate)new NamePredicate("Goblin Tutor"));
    }
}

