/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.awt.Color;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.abilities.hint.HintUtils;
import mage.cards.Card;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.CardsAmountDrawnThisTurnWatcher;

class GodEternalKefnetDrawCardReplacementEffect
extends ReplacementEffectImpl {
    GodEternalKefnetDrawCardReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral);
        this.staticText = "You may reveal the first card you draw each turn as you draw it. Whenever you reveal an instant or sorcery card this way, copy that card and you may cast the copy. That copy costs {2} less to cast";
    }

    private GodEternalKefnetDrawCardReplacementEffect(GodEternalKefnetDrawCardReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GodEternalKefnetDrawCardReplacementEffect copy() {
        return new GodEternalKefnetDrawCardReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent god = game.getPermanent(source.getSourceId());
        Player you = game.getPlayer(source.getControllerId());
        if (god == null && you == null) {
            return false;
        }
        Card topCard = you.getLibrary().getFromTop(game);
        if (topCard == null) {
            return false;
        }
        you.setTopCardRevealed(true);
        if (topCard.isInstantOrSorcery(game) && you.chooseUse(this.outcome, "Copy " + topCard.getName() + " and cast it for {2} less?", source, game)) {
            Card blueprint = topCard.copy();
            if (blueprint instanceof SplitCard) {
                ((SplitCard)blueprint).getLeftHalfCard().addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2)));
                ((SplitCard)blueprint).getRightHalfCard().addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2)));
            } else if (blueprint instanceof ModalDoubleFacedCard) {
                ((ModalDoubleFacedCard)blueprint).getLeftHalfCard().addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2)));
                ((ModalDoubleFacedCard)blueprint).getRightHalfCard().addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2)));
            } else {
                blueprint.addAbility((Ability)new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2)));
            }
            Card copiedCard = game.copyCard(blueprint, source, source.getControllerId());
            game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
            you.cast(you.chooseAbilityForCast(copiedCard, game, false), game, false, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    String getAppliedMark(Game game, Ability source) {
        return source.getId() + "-applied-" + source.getControllerId() + "-" + game.getState().getTurnNum();
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!event.getPlayerId().equals(source.getControllerId())) {
            return false;
        }
        Permanent god = game.getPermanent(source.getSourceId());
        Player you = game.getPlayer(source.getControllerId());
        if (god == null && you == null) {
            return false;
        }
        Card topCard = you.getLibrary().getFromTop(game);
        if (topCard == null) {
            return false;
        }
        CardsAmountDrawnThisTurnWatcher watcher = (CardsAmountDrawnThisTurnWatcher)game.getState().getWatcher(CardsAmountDrawnThisTurnWatcher.class);
        if (watcher != null && watcher.getAmountCardsDrawn(event.getPlayerId()) != 0) {
            return false;
        }
        String mark = this.getAppliedMark(game, source);
        if (game.getState().getValue(mark) != null) {
            return false;
        }
        game.getState().setValue(mark, (Object)true);
        String mes = topCard.getName() + ", " + (topCard.isInstantOrSorcery(game) ? HintUtils.prepareText((String)"you can copy it and cast {2} less", (Color)Color.green) : HintUtils.prepareText((String)"you can't copy it", (Color)Color.red));
        return you.chooseUse(Outcome.Benefit, "Reveal first drawn card (" + mes + ")?", source, game);
    }
}

