/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class GodsendRuleModifyingEffect
extends ContinuousRuleModifyingEffectImpl {
    GodsendRuleModifyingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Your opponents can't cast spells with the same name as a card exiled with {this}";
    }

    private GodsendRuleModifyingEffect(GodsendRuleModifyingEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public GodsendRuleModifyingEffect copy() {
        return new GodsendRuleModifyingEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast this spell because a card with the same name is exiled by " + mageObject.getLogName() + '.';
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ExileZone exileZone;
        MageObject object;
        if (game.getOpponents(source.getControllerId()).contains(event.getPlayerId()) && (object = game.getObject(event.getSourceId())) != null && (exileZone = game.getExile().getExileZone(CardUtil.getCardExileZoneId((Game)game, (Ability)source))) != null) {
            for (Card card : exileZone.getCards(game)) {
                if (!card.getName().equals(object.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

