/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.MultiAmountMessage;

class GoldberryRiverDaughterToEffect
extends OneShotEffect {
    GoldberryRiverDaughterToEffect() {
        super(Outcome.Neutral);
        this.staticText = "Move one or more counters from Goldberry onto another target permanent you control. If you do, draw a card.";
    }

    private GoldberryRiverDaughterToEffect(GoldberryRiverDaughterToEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoldberryRiverDaughterToEffect copy() {
        return new GoldberryRiverDaughterToEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List choices;
        int total;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent toPermanent = game.getPermanent(source.getFirstTarget());
        Permanent fromPermanent = game.getPermanent(source.getSourceId());
        if (fromPermanent == null || toPermanent == null || controller == null || fromPermanent.getCounters(game).size() == 0) {
            return false;
        }
        ArrayList<Counter> counters = new ArrayList<Counter>(fromPermanent.getCounters(game).values());
        counters.sort(Comparator.comparing(Counter::getName));
        List messages = counters.stream().map(c -> new MultiAmountMessage(c.getName() + " (" + c.getCount() + ")", 0, c.getCount())).collect(Collectors.toList());
        int totalMin = 1;
        int totalMax = messages.stream().mapToInt(m -> m.max).sum();
        while ((total = (choices = controller.getMultiAmountWithIndividualConstraints(Outcome.Neutral, messages, totalMin, totalMax, MultiAmountType.COUNTERS, game)).stream().mapToInt(x -> x).sum()) < totalMin && controller.canRespond()) {
        }
        boolean movedCounters = false;
        for (int i = 0; i < choices.size(); ++i) {
            Integer amount = (Integer)choices.get(i);
            if (amount <= 0) continue;
            String counterName = ((Counter)counters.get(i)).getName();
            movedCounters |= toPermanent.addCounters(CounterType.findByName((String)counterName).createInstance(amount.intValue()), source, game);
            fromPermanent.removeCounters(counterName, amount.intValue(), source, game);
            game.informPlayers(controller.getLogName() + "moved " + amount + " " + counterName + " counter" + (amount > 1 ? "s" : "") + " from " + fromPermanent.getLogName() + "to " + toPermanent.getLogName() + ".");
        }
        if (movedCounters) {
            controller.drawCards(1, source, game);
        }
        return false;
    }
}

