/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.RebelRedToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class GoldwardensGambitEffect
extends OneShotEffect {
    GoldwardensGambitEffect() {
        super(Outcome.Benefit);
        this.staticText = "create five 2/2 red Rebel creature tokens. They gain haste until end of turn. For each of those tokens, you may attach an Equipment you control to it";
    }

    private GoldwardensGambitEffect(GoldwardensGambitEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoldwardensGambitEffect copy() {
        return new GoldwardensGambitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        RebelRedToken token = new RebelRedToken();
        token.putOntoBattlefield(5, game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        if (game.getBattlefield().count(StaticFilters.FILTER_CONTROLLED_PERMANENT_EQUIPMENT, source.getControllerId(), source, game) < 1) {
            return true;
        }
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null || !player.chooseUse(Outcome.BoostCreature, "Attach an equipment you control to " + permanent.getIdName() + '?', source, game)) continue;
            TargetPermanent target = new TargetPermanent(0, 1, StaticFilters.FILTER_CONTROLLED_PERMANENT_EQUIPMENT, true);
            player.choose(Outcome.BoostCreature, (Target)target, source, game);
            permanent.addAttachment(target.getFirstTarget(), source, game);
        }
        return true;
    }
}

