/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.ToxicAbility;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.util.CardUtil;

class GoliathHatcheryEffect
extends OneShotEffect {
    GoliathHatcheryEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a creature you control, then draw cards equal to its total toxic value";
    }

    private GoliathHatcheryEffect(GoliathHatcheryEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoliathHatcheryEffect copy() {
        return new GoliathHatcheryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source, game, 1)) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        int amount = CardUtil.castStream((Stream)permanent.getAbilities(game).stream(), ToxicAbility.class).mapToInt(ToxicAbility::getAmount).sum();
        return amount > 0 && player.drawCards(amount, source, game) > 0;
    }
}

