/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.g.GontiExileEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GontiTriggeredAbility
extends TriggeredAbilityImpl {
    public GontiTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GontiExileEffect(), false);
        this.setTriggerPhrase("Whenever a creature deals combat damage to one of your opponents, ");
    }

    private GontiTriggeredAbility(GontiTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GontiTriggeredAbility copy() {
        return new GontiTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        DamagedEvent damagedEvent = (DamagedEvent)event;
        if (damagedEvent.isCombatDamage() && game.getOpponents(this.controllerId).contains(damagedEvent.getTargetId()) && (permanent = game.getPermanentOrLKIBattlefield(damagedEvent.getSourceId())) != null && permanent.isCreature(game)) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(damagedEvent.getTargetId()));
            this.getEffects().setValue("controllerId", (Object)permanent.getControllerId());
            return true;
        }
        return false;
    }
}

