/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class GrandMoffTarkinTriggeredAbility
extends TriggeredAbilityImpl {
    public GrandMoffTarkinTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.setTriggerPhrase("At the beginning of each opponent's upkeep, ");
    }

    private GrandMoffTarkinTriggeredAbility(GrandMoffTarkinTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Player opponent;
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId()) && (opponent = game.getPlayer(event.getPlayerId())) != null) {
            this.getTargets().clear();
            FilterCreaturePermanent filter = new FilterCreaturePermanent("target creature that player controls");
            filter.add((Predicate)new ControllerIdPredicate(event.getPlayerId()));
            TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
            this.addTarget((Target)target);
            return true;
        }
        return false;
    }

    public GrandMoffTarkinTriggeredAbility copy() {
        return new GrandMoffTarkinTriggeredAbility(this);
    }
}

