/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.TargetPermanent;

class GraspOfTheHieromancerTriggeredAbility
extends TriggeredAbilityImpl {
    public GraspOfTheHieromancerTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
    }

    private GraspOfTheHieromancerTriggeredAbility(GraspOfTheHieromancerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID defendingPlayerId;
        if (game.getCombat().getAttackers().contains(this.getSourceId()) && (defendingPlayerId = game.getCombat().getDefendingPlayerId(this.getSourceId(), game)) != null) {
            this.getTargets().clear();
            FilterCreaturePermanent filter = new FilterCreaturePermanent("creature defending player controls");
            UUID defenderId = game.getCombat().getDefenderId(this.getSourceId());
            filter.add((Predicate)new ControllerIdPredicate(defenderId));
            this.addTarget((Target)new TargetPermanent((FilterPermanent)filter));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} attacks, tap target creature defending player controls.";
    }

    public GraspOfTheHieromancerTriggeredAbility copy() {
        return new GraspOfTheHieromancerTriggeredAbility(this);
    }
}

