/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.g.GraveBetrayalReplacementEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GraveBetrayalEffect
extends OneShotEffect {
    GraveBetrayalEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = " return the creature to the battlefield under your control with an additional +1/+1 counter. That creature is a black Zombie in addition to its other colors and types";
    }

    private GraveBetrayalEffect(GraveBetrayalEffect effect) {
        super((OneShotEffect)effect);
    }

    public GraveBetrayalEffect copy() {
        return new GraveBetrayalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (card != null) {
                GraveBetrayalReplacementEffect effect = new GraveBetrayalReplacementEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId()));
                game.addEffect((ContinuousEffect)effect, source);
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

