/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.AddCreatureTypeAdditionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GraveBetrayalReplacementEffect
extends ReplacementEffectImpl {
    GraveBetrayalReplacementEffect() {
        super(Duration.EndOfStep, Outcome.BoostCreature);
    }

    private GraveBetrayalReplacementEffect(GraveBetrayalReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null) {
            creature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
            AddCreatureTypeAdditionEffect effect = new AddCreatureTypeAdditionEffect(SubType.ZOMBIE, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), creature.getZoneChangeCounter(game) + 1));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return false;
    }

    public GraveBetrayalReplacementEffect copy() {
        return new GraveBetrayalReplacementEffect(this);
    }
}

