/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class GraviticPunchEffect
extends OneShotEffect {
    GraviticPunchEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature you control deals damage equal to its power to target player.";
    }

    private GraviticPunchEffect(GraviticPunchEffect effect) {
        super((OneShotEffect)effect);
    }

    public GraviticPunchEffect copy() {
        return new GraviticPunchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent controlledCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        Player player = game.getPlayer(((Target)source.getTargets().get(1)).getFirstTarget());
        if (player == null || controlledCreature == null) {
            return false;
        }
        player.damage(controlledCreature.getPower().getValue(), controlledCreature.getId(), source, game);
        return true;
    }
}

