/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.g.GravityWellEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GravityWellTriggeredAbility
extends TriggeredAbilityImpl {
    public GravityWellTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GravityWellEffect());
        this.setTriggerPhrase("Whenever a creature with flying attacks, ");
    }

    private GravityWellTriggeredAbility(GravityWellTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attacker = game.getPermanent(event.getSourceId());
        if (attacker != null && attacker.getAbilities().contains((Ability)FlyingAbility.getInstance())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            }
            return true;
        }
        return false;
    }

    public GravityWellTriggeredAbility copy() {
        return new GravityWellTriggeredAbility(this);
    }
}

