/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class GreasefangOkibaBossEffect
extends OneShotEffect {
    GreasefangOkibaBossEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "return target Vehicle card from your graveyard to the battlefield. It gains haste. Return it to its owner's hand at the beginning of your next end step";
    }

    private GreasefangOkibaBossEffect(GreasefangOkibaBossEffect effect) {
        super((OneShotEffect)effect);
    }

    public GreasefangOkibaBossEffect copy() {
        return new GreasefangOkibaBossEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (controller == null || card == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            GainAbilityTargetEffect hasteEffect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom);
            hasteEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)hasteEffect, source);
            OneShotEffect bounceEffect = new ReturnToHandTargetEffect().setText("return it to your hand");
            bounceEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)bounceEffect), source);
        }
        return true;
    }
}

