/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.g.GreatbowDoyenEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class GreatbowDoyenTriggeredAbility
extends TriggeredAbilityImpl {
    public GreatbowDoyenTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GreatbowDoyenEffect());
        this.setTriggerPhrase("Whenever an Archer you control deals damage to a creature, ");
    }

    private GreatbowDoyenTriggeredAbility(GreatbowDoyenTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GreatbowDoyenTriggeredAbility copy() {
        return new GreatbowDoyenTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent creature = game.getPermanent(event.getSourceId());
        Permanent damagedCreature = game.getPermanent(event.getTargetId());
        if (creature != null && damagedCreature != null && creature.isCreature(game) && creature.hasSubtype(SubType.ARCHER, game) && creature.isControlledBy(this.controllerId)) {
            ((Effect)this.getEffects().get(0)).setValue("damageAmount", (Object)event.getAmount());
            ((Effect)this.getEffects().get(0)).setValue("controller", (Object)damagedCreature.getControllerId());
            ((Effect)this.getEffects().get(0)).setValue("source", (Object)event.getSourceId());
            return true;
        }
        return false;
    }
}

