/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;

class GreenSlimeEffect
extends OneShotEffect {
    GreenSlimeEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target activated or triggered ability from an artifact or enchantment source. If a permanent's ability is countered this way, destroy that permanent";
    }

    private GreenSlimeEffect(GreenSlimeEffect effect) {
        super((OneShotEffect)effect);
    }

    public GreenSlimeEffect copy() {
        return new GreenSlimeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (stackObject == null) {
            return false;
        }
        Permanent permanent = stackObject.getStackAbility().getSourcePermanentIfItStillExists(game);
        if (game.getStack().counter(stackObject.getId(), source, game) && permanent != null) {
            permanent.destroy(source, game);
        }
        return true;
    }
}

