/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardAndOrCardInLibrary;
import mage.util.CardUtil;

class GreenSunsTwilightEffect
extends OneShotEffect {
    GreenSunsTwilightEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top X plus one cards of your library. Choose a creature card and/or a land card from among them. Put those cards into your hand and the rest on the bottom of your library in a random order. If X is 5 or more, instead put the chosen cards onto the battlefield or into your hand and the rest on the bottom of your library in a random order";
    }

    private GreenSunsTwilightEffect(GreenSunsTwilightEffect effect) {
        super((OneShotEffect)effect);
    }

    public GreenSunsTwilightEffect copy() {
        return new GreenSunsTwilightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, xValue + 1));
        player.revealCards(source, (Cards)cards, game);
        TargetCardAndOrCardInLibrary target = new TargetCardAndOrCardInLibrary(CardType.CREATURE, CardType.LAND);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl toMove = new CardsImpl((Collection)target.getTargets());
        if (!toMove.isEmpty()) {
            Zone zone = xValue >= 5 && player.chooseUse(Outcome.PutCardInPlay, "Put the chosen cards onto the battlefield or into your hand?", null, "Battlefield", "Hand", source, game) ? Zone.BATTLEFIELD : Zone.HAND;
            player.moveCards((Cards)toMove, zone, source, game);
        }
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

