/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;

class GreyHostReinforcementsEffect
extends OneShotEffect {
    GreyHostReinforcementsEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target player's graveyard. Put a number of +1/+1 counters on {this} equal to the number of creature cards exiled this way";
    }

    private GreyHostReinforcementsEffect(GreyHostReinforcementsEffect effect) {
        super((OneShotEffect)effect);
    }

    public GreyHostReinforcementsEffect copy() {
        return new GreyHostReinforcementsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        int totalCreatures = player.getGraveyard().count((FilterCard)new FilterCreatureCard(), game);
        controller.moveCards((Cards)player.getGraveyard(), Zone.EXILED, source, game);
        return new AddCountersSourceEffect(CounterType.P1P1.createInstance(totalCreatures)).apply(game, source);
    }
}

