/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GriefTyrantEffect
extends OneShotEffect {
    public GriefTyrantEffect() {
        super(Outcome.Neutral);
        this.staticText = "put a -1/-1 counter on target creature for each -1/-1 counter on {this}";
    }

    private GriefTyrantEffect(GriefTyrantEffect effect) {
        super((OneShotEffect)effect);
    }

    public GriefTyrantEffect copy() {
        return new GriefTyrantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent griefTyrant = game.getPermanentOrLKIBattlefield(source.getSourceId());
        int countersOnGriefTyrant = griefTyrant.getCounters(game).getCount(CounterType.M1M1);
        if (targetCreature != null) {
            targetCreature.addCounters(CounterType.M1M1.createInstance(countersOnGriefTyrant), source.getControllerId(), source, game);
            return true;
        }
        return false;
    }
}

