/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseHalfLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GrievousWoundTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    GrievousWoundTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseHalfLifeTargetEffect().setText("they lose half their life, rounded up"));
        this.setTriggerPhrase("Whenever enchanted player is dealt damage, ");
    }

    private GrievousWoundTriggeredAbility(GrievousWoundTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GrievousWoundTriggeredAbility copy() {
        return new GrievousWoundTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attachment = this.getSourcePermanentIfItStillExists(game);
        if (attachment == null || !event.getTargetId().equals(attachment.getAttachedTo())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId()));
        return true;
    }
}

