/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class GriftersBladeChooseCreatureEffect
extends OneShotEffect {
    GriftersBladeChooseCreatureEffect(Outcome outcome) {
        super(outcome);
        this.staticText = "choose a creature you control it could be attached to. If you do, it enters attached to that creature";
    }

    private GriftersBladeChooseCreatureEffect(GriftersBladeChooseCreatureEffect effect) {
        super((OneShotEffect)effect);
    }

    public GriftersBladeChooseCreatureEffect copy() {
        return new GriftersBladeChooseCreatureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        if (controller != null && mageObject != null) {
            Permanent attachToCreature;
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            if (controller.choose(this.outcome, (Target)target, source, game) && (attachToCreature = game.getPermanent(target.getFirstTarget())) != null) {
                attachToCreature.addAttachment(mageObject.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

